/*== DIGISTANT 14xx  bp14xx Include File ======================*/
#include <vpptype.h>

/*== defines for serial communication =========================*/
#define NUL      0x00
#define STX      0x02
#define ETX      0x03
#define EOT      0x04
#define ENQ      0x05
#define ACK      0x06
#define NAK      0x15

/*== defines for program=======================================*/
#define bp14xx_MAX_INSTR   10
#define bp14xx_MAX_CMD     100
#define bp14xx_GPIB        0
#define bp14xx_SERIAL      1

/*== GLOBAL FUNCTION DECLARATIONS =========================================*/
int _VI_FUNC bp14xx_init_gpib (int address, int *instrumentID);
int _VI_FUNC bp14xx_init_serial (int COMPort, int baudRate, double timeoutseconds,
                                 int blockCheck, int groupAddress, int userAddress,
                                 int *instrumentID);
int _VI_FUNC bp14xx_local_gpib (int instrumentID);
int _VI_FUNC bp14xx_set_value (int instrumentID, char outputValue[]);
int _VI_FUNC bp14xx_get_value (int instrumentID, char inputValue[]);
int _VI_FUNC bp14xx_close (int instrumentID);

/*int bp14xx_init_gpib (int,int*);
int bp14xx_init_serial(int ,int,double,int,int,int,int *);
int bp14xx_set_value(int,char*);
int bp14xx_get_value(int,char*);
int bp14xx_local_gpib (int);
int bp14xx_timout_gpib(int ,int);
int bp14xx_poll_gpib (int,char*);
int bp14xx_close (int);*/

/*=============================== END =====================================*/
